package mcfall.raytracer.tests;

import java.awt.Dimension;

import mcfall.math.IncompatibleMatrixException;
import mcfall.math.Point;
import mcfall.math.Ray;
import mcfall.math.Vector;
import mcfall.raytracer.Camera;
import mcfall.raytracer.objects.GenericSquare;

import org.junit.Before;
import org.junit.Test;

public class ProjectionExtent extends TestCase{
	Camera c;
	GenericSquare gs;
	@Before
	public void setUp() throws Exception {
		c = new Camera(new Point(0,-3,-3),new Point(0,10,0),90,1,.5,new Dimension(200,200));
		gs = new GenericSquare();
	}
	@Test
	public void testCameraColumnRowRayInverses() throws IncompatibleMatrixException {
		for(int row = 0;row<200;row++) {
			for(int col = 0;col<200;col++) {
				Ray r = c.rayThrough(col, row);
				r.setDirection(Vector.fromColumnMatrix(r.getDirection().scalarMultiply(Math.random()*100d-50d)));
				Vector v = c.invertRayThrough(r);
				assertAlmostEquals(v.getValueAt(1),col);
				assertAlmostEquals(v.getValueAt(2),row);
				assertAlmostEquals(v.getValueAt(3),1d);
				
			}
		}
	}
	@Test
	public void testObject() throws IncompatibleMatrixException {
		for(int row = 0;row<200;row++) {
			for(int col = 0;col<200;col++) {
				Ray r = c.rayThrough(col, row);
				r.setDirection(Vector.fromColumnMatrix(r.getDirection().scalarMultiply(Math.random()*100d-50d)));
				Vector v = c.invertRayThrough(r);
				boolean hits = gs.hitTime(r).size()>0;
				if(hits) {
					assert(gs.hits(row, col));
				}
			}
		}
	}

}
